/*
 * Decompiled with CFR 0.152.
 */
package frc.input;

import frc.input.JInputController;
import net.java.games.input.Component;

public class JInputComponent {
    private final JInputController controller;
    private final Component component;
    private String ID;
    private String name;
    private String toString;

    public JInputComponent(JInputController jInputController, Component component) {
        this(jInputController, component, JInputComponent.buildID(component));
    }

    private JInputComponent(JInputController jInputController, Component component, String string) {
        this.controller = jInputController;
        this.component = component;
        this.ID = string;
    }

    public final String toString() {
        if (this.toString == null) {
            String string = this.getName();
            Component.Identifier identifier = this.getType();
            if (identifier.getClass().getName().indexOf("$Button") >= 0) {
                try {
                    Integer.parseInt(identifier.getName());
                }
                catch (NumberFormatException numberFormatException) {
                    string = identifier.getName();
                }
            }
            this.toString = " " + string + " ";
        }
        return this.toString;
    }

    public final String getID() {
        return this.ID;
    }

    public final JInputController getController() {
        return this.controller;
    }

    public Component.Identifier getType() {
        return this.component.getIdentifier();
    }

    public float getData() {
        return this.component.getPollData();
    }

    public String getName() {
        return this.name != null ? this.name : this.component.getName();
    }

    public boolean isAnalog() {
        return this.component.isAnalog();
    }

    public boolean isRelative() {
        return this.component.isRelative();
    }

    public final boolean embodies(Object object) {
        if (object instanceof JInputComponent) {
            return ((JInputComponent)object).component.equals(this.component);
        }
        if (object instanceof Component) {
            return object.equals(this.component);
        }
        if (object instanceof String) {
            return object.equals(this.ID);
        }
        if (object instanceof Component.Identifier) {
            return object.equals(this.getType());
        }
        return false;
    }

    final void setID(String string) {
        this.ID = string;
        this.toString = null;
    }

    final void setName(String string) {
        this.name = string;
        this.toString = null;
    }

    private static final String buildID(Component component) {
        String string = String.valueOf(component.getIdentifier().getName()) + "." + component.getName();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static JInputComponent createFake(JInputController jInputController, String string) {
        return new JInputComponent(jInputController, null, "FAKE." + string){

            public final Component.Identifier getType() {
                return null;
            }

            public final float getData() {
                return 0.0f;
            }

            public final String getName() {
                return "Fake Component";
            }

            public final boolean isAnalog() {
                return false;
            }

            public final boolean isRelative() {
                return false;
            }
        };
    }

    /* synthetic */ JInputComponent(JInputController jInputController, Component component, String string, JInputComponent jInputComponent) {
        this(jInputController, component, string);
    }
}

